/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

public final class VWAdminDetailsDialog
extends VWModalDialog {
    private JPanel buttonPanel = new JPanel();
    private Container container = this.getContentPane();
    private JScrollPane scrollPane;
    private JButton m_okButton = null;
    private JButton m_helpButton = null;
    private JTextArea m_infoTextArea = null;
    private boolean m_bCanceled = false;
    private JTable m_table = null;
    private DefaultTableModel m_tableModel = null;
    private Vector m_vErrors = new Vector();

    public VWAdminDetailsDialog(Frame parent, Vector errorsVector) {
        super(parent);
        if (errorsVector.size() == 0) {
            JOptionPane.showMessageDialog(this.m_parent, VWResource.s_noErrorsRetrieved, VWResource.s_detailsTitle, 1, null);
            return;
        }
        this.m_vErrors = errorsVector;
        try {
            this.setResizable(true);
            Dimension dim = VWStringUtils.stringToDimension("665,275");
            if (dim == null) {
                dim = new Dimension(600, 250);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setLocationRelativeTo(parent);
            this.setTitle(VWResource.s_detailsTitle);
            this.buildTable();
            this.scrollPane = new JScrollPane(this.m_table);
            this.buildButtonPanel();
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)this.scrollPane, "Center");
            this.container.setLayout(new BorderLayout());
            this.container.add((Component)mainPanel, "Center");
            this.container.add((Component)this.buttonPanel, "Last");
            Component filler = Box.createVerticalStrut(20);
            this.getContentPane().add(filler, "First");
            this.container.add(Box.createHorizontalStrut(20), "Before");
            this.container.add(Box.createHorizontalStrut(20), "After");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    private void buildButtonPanel() {
        this.m_okButton = new JButton(VWResource.s_OK);
        VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
        this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.m_okButton);
        this.buttonPanel.add(Box.createHorizontalStrut(20));
        if (this.m_okButton != null) {
            this.m_okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWAdminDetailsDialog.this.m_bCanceled = false;
                    VWAdminDetailsDialog.this.setVisible(false);
                }
            });
        }
    }

    private void buildTable() {
        Vector rowCache = new Vector();
        Vector<String> columnNames = new Vector<String>();
        columnNames.addElement(VWResource.s_participantName);
        columnNames.addElement(VWResource.s_stepLabel);
        columnNames.addElement(VWResource.s_lockedBy);
        columnNames.addElement(VWResource.s_errorMessage);
        for (int i = 0; i < this.m_vErrors.size(); ++i) {
            VWAdminErrorDataObj errData = (VWAdminErrorDataObj)this.m_vErrors.elementAt(i);
            this.insertElementToVector(rowCache, errData);
        }
        this.m_tableModel = new DefaultTableModel(rowCache, columnNames);
        this.m_table = new VWTable(this.m_tableModel);
        this.m_table.setEnabled(false);
        this.m_table.setShowGrid(false);
        VWAccessibilityHelper.setAccessibility(this.m_table, this, VWResource.s_detailsTable, VWResource.s_detailsTable);
        this.m_table.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (VWAdminDetailsDialog.this.m_table == null || VWAdminDetailsDialog.this.m_table.getModel() == null || VWAdminDetailsDialog.this.m_table.getRowCount() == 0) {
                    FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        });
    }

    private void insertElementToVector(Vector vector, VWAdminErrorDataObj errData) {
        Vector<String> rowData = new Vector<String>();
        try {
            VWWorkObject wob = errData.getWob();
            VWParticipantItem vwParticipantItem = new VWParticipantItem(wob.getParticipantNamePx());
            rowData.addElement(vwParticipantItem.getDisplayName());
            rowData.addElement(wob.getStepName());
            vwParticipantItem = new VWParticipantItem(wob.getLockedUserPx());
            rowData.addElement(vwParticipantItem.getDisplayName());
            rowData.addElement(errData.getErrorMessage());
            vector.addElement(rowData);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

